/*
 * VRT RULES
 * 
 * Copyright (C) 2005 Sourcefire, Inc.
 * 
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>

   DOES NOT USE BUILT-IN FUNCTIONS

   Additional functionality written by Patrick Mullen <pmullen@sourcefire.com>

alert tcp $EXTERNAL_NET any -> $HOME_NET 389 (msg:"EXPLOIT Microsoft Active Directory LDAP denial of service attempt"; flow:to_server,established; content:"|30|"; depth:1; reference:url,technet.microsoft.com/en-us/security/bulletin/ms08-003; reference:cve,2008-0088;  classtype:attempted-dos; sid:13475; rev:1;)

 */

#include <string.h>

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"

#include "so-util_ber.h"

//#define DEBUG
#ifdef DEBUG
#define DEBUG_SO(code) code
#else
#define DEBUG_SO(code)
#endif


/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule13475flow0 = 
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule13475option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    {
        &rule13475flow0
    }
};

// content:"0", depth 1; 
static ContentInfo rule13475content1 = 
{
    (uint8_t *)"0", /* pattern (now in snort content format) */
    1, /* depth */
    0, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0 /* increment length*/
};

static RuleOption rule13475option1 = 
{
    OPTION_TYPE_CONTENT,
    {
        &rule13475content1
    }
};

/* references for sid 13475 */
/* reference: cve "2008-0088"; */
static RuleReference rule13475ref1 = 
{
    "cve", /* type */
    "2008-0088" /* value */
};

/* reference: url "technet.microsoft.com/en-us/security/bulletin/ms08-003"; */
static RuleReference rule13475ref2 = 
{
    "url", /* type */
    "technet.microsoft.com/en-us/security/bulletin/ms08-003" /* value */
};

static RuleReference *rule13475refs[] =
{
    &rule13475ref1,
    &rule13475ref2,
    NULL
};
RuleOption *rule13475options[] =
{
    &rule13475option0,
    &rule13475option1,
    NULL
};

/* declare detection functions */
int rule13475eval(void *p);

static RuleMetaData rule13475service1 =
{
    "service ldap"
};

static RuleMetaData rule13475policy1 =
{
    "policy max-detect-ips drop"
};

static RuleMetaData *rule13475metadata[] =
{
    &rule13475service1,
    &rule13475policy1,
    NULL
};


Rule rule13475 = {
   
   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "389", /* DSTPORT   */
   },
   /* metadata */
   { 
       3,  /* genid (HARDCODED!!!) */
       13475, /* sigid */
       12, /* revision */
   
       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "OS-WINDOWS Microsoft Active Directory LDAP denial of service attempt",     /* message */
       rule13475refs /* ptr to references */
        ,rule13475metadata
   },
   rule13475options, /* ptr to rule options */
   &rule13475eval, /* use the built in detection function */
   0 /* am I initialized yet? */
};


/* detection functions */
int rule13475eval(void *p) {
   int retval;

   uint32_t page_oid_len, sort_oid_len;
   const uint8_t *page_oid_ptr, *sort_oid_ptr;

   const uint8_t *cursor_normal, *end_of_payload;

   uint8_t *stored_data, *stored_data_ptr;

   SFSnortPacket *sp = (SFSnortPacket *) p;

   BER_ELEMENT element;

   DEBUG_SO(char name[] = "ad_ldap");
   DEBUG_SO(printf("%s: Entering\n", name));

   if((sp == NULL) || (sp->stream_session_ptr == NULL))
      return RULE_NOMATCH;

   if(sp->payload == NULL)
      return RULE_NOMATCH;

   // flow:established, to_server;
   if (checkFlow(p, rule13475options[0]->option_u.flowFlags) <= 0 )
      return RULE_NOMATCH;

   if(getBuffer(sp, CONTENT_BUF_NORMALIZED, &cursor_normal, &end_of_payload) <= 0)
      return RULE_NOMATCH;

   if((end_of_payload - cursor_normal) < 100)
      return RULE_NOMATCH;
    
   BER_DATA(0x30);  // Univ Seq
   BER_SKIP(0x02); // Message ID
   BER_SKIP(0x63); // Search Request  /* BER_DATA(0x63); // Search Request */

   // The bug is inside the controls for a search request
   BER_DATA(0xa0); // ldap controls
   BER_DATA(0x30); // page control

   // Now the fun stuff!
   // Page OID
   retval = ber_get_element(sp, cursor_normal, &element);
   if(retval < 0 || retval < element.data_len) {
      DEBUG_SO(printf("%s: Failed reading Page OID - retval=%d element.data_len=%d\n",
                 name, retval, element.data_len));
      return RULE_NOMATCH;
   }

   DEBUG_SO(printf("%s: Read Page OID - retval=%d element.data_len=%d\n", name, retval, element.data_len));
 
   // Store the Page and Sort OIDs if no data already exists
   // Get the pointer from the API
   stored_data = (uint8_t *)getRuleData(sp, rule13475.info.sigID);

   if(!stored_data) {

      page_oid_len = element.data_len;
      page_oid_ptr = element.data.data_ptr;

      // Now jump over cruft to get to the Sort OID
      cursor_normal += element.total_len;

      BER_SKIP(0x01); // Control Critical
      BER_SKIP(0x04); // Control Value
      BER_DATA(0x30); // Sort Control

      DEBUG_SO(printf("%s: Found Sort Control\n", name));

      // Sort OID
      retval = ber_get_element(sp, cursor_normal, &element);
      if(retval < 0 || retval < element.data_len) {
         DEBUG_SO(printf("%s: Failed reading Sort OID - retval=%d element.data_len=%d\n",
                    name, retval, element.data_len));
         return RULE_NOMATCH;
      }

      sort_oid_len = element.data_len;
      sort_oid_ptr = element.data.data_ptr;

      /* Let's try to avoid a memory consumption issue, eh? */
      if((page_oid_len > 300) || (sort_oid_len > 300))
         return RULE_NOMATCH;

      stored_data = (uint8_t*)allocRuleData(4 + page_oid_len + 4 + sort_oid_len);

      if(!stored_data)
         return RULE_NOMATCH;

      if(storeRuleData(sp, stored_data, rule13475.info.sigID, &freeRuleData) < 0)
      {
         freeRuleData(stored_data);
         return RULE_NOMATCH;
      }

      stored_data_ptr = stored_data;

      // Store the info: sigid, page oid len and value, sort oid len and value
      *((uint32_t *)stored_data_ptr) = (uint32_t)page_oid_len;
      stored_data_ptr += 4;
      memcpy(stored_data_ptr, page_oid_ptr, page_oid_len);
      stored_data_ptr += page_oid_len;

      *((uint32_t *)stored_data_ptr) = (uint32_t)sort_oid_len;
      stored_data_ptr += 4;
      memcpy(stored_data_ptr, sort_oid_ptr, sort_oid_len);

   } else { // we have stored data. compare it to this packet's data

      stored_data_ptr = stored_data;

      // Compare the Page OIDs
      if(*((uint32_t *)stored_data_ptr) != element.data_len) {
         DEBUG_SO(printf("%s: Page OIDs not same len so cannot match (%d, %d)\n", name, *((uint32_t *)stored_data_ptr), element.data_len));
         return RULE_NOMATCH;
      }

      stored_data_ptr += 4;

      if(memcmp(stored_data_ptr, element.data.data_ptr, element.data_len)) {
         DEBUG_SO(printf("%s: Page OIDs did not match\n", name));
         return RULE_NOMATCH;
      }
      
      stored_data_ptr += element.data_len;
      DEBUG_SO(printf("%s: Matched Page OIDs\n", name));

      // Now jump over cruft to get to the Sort OID
      cursor_normal += element.total_len;

      BER_SKIP(0x01); // Control Critical
      BER_SKIP(0x04); // Control Value
      BER_DATA(0x30); // Sort Control

      DEBUG_SO(printf("%s: Found Sort Control\n", name));

      // Sort OID
      retval = ber_get_element(sp, cursor_normal, &element);

      if(retval < 0) {
         DEBUG_SO(printf("%s: failed to read Sort OID\n", name));
         return RULE_NOMATCH;
      }

      // Compare values.  If lengths are different, the OIDs are different
      // We can do this check w/out having the full Sort OID
      if(*(uint32_t *)stored_data_ptr != element.data_len) {
         DEBUG_SO(printf("%s: Lengths are different (%d, %d)\n", name, *(uint32_t *)stored_data_ptr, element.data_len));
         return RULE_MATCH;
      }

      stored_data_ptr += 4;

      // Same length, do a memcmp after assuring we have the data
      if(retval < element.data_len) {
         DEBUG_SO(printf("%s: Do not have complete Sort OID - retval=%d element.data_len=%d\n",
                    name, retval, element.data_len));
         return RULE_NOMATCH;
      }

      if(memcmp(stored_data_ptr, element.data.data_ptr, element.data_len)) {
         DEBUG_SO(printf("%s: Sort OIDs did not match\n", name));
         return RULE_MATCH;
      }
   }

   return RULE_NOMATCH;
}

/*
Rule *rules[] = {
    &rule13475,
    NULL
};
*/
